/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kuma;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.kuma.ManagedKeyMappingRegistry;
import net.blay09.mods.kuma.VanillaManagedKeyMapping;
import net.blay09.mods.kuma.VirtualManagedKeyMapping;
import net.blay09.mods.kuma.api.InputBinding;
import net.blay09.mods.kuma.api.KeyConflictContext;
import net.blay09.mods.kuma.api.Kuma;
import net.blay09.mods.kuma.api.ManagedKeyMapping;
import net.blay09.mods.kuma.api.ScreenInputEventHandler;
import net.blay09.mods.kuma.api.WorldInputEventHandler;
import net.minecraft.class_2960;

public abstract class AbstractManagedKeyMappingBuilder
implements ManagedKeyMapping.Builder {
    protected final class_2960 id;
    protected String category;
    protected KeyConflictContext context;
    protected InputBinding defaultBinding = InputBinding.none();
    protected List<InputBinding> fallbackBindings = new ArrayList<InputBinding>();
    protected boolean forceVirtual;
    protected WorldInputEventHandler worldInputHandler;
    protected ScreenInputEventHandler screenInputHandler;
    protected boolean keyRepeat = true;

    public AbstractManagedKeyMappingBuilder(class_2960 id) {
        this.id = id;
        this.category = "key.categories." + id.method_12836();
    }

    @Override
    public ManagedKeyMapping.Builder overrideCategory(String category) {
        this.category = category;
        return this;
    }

    @Override
    public ManagedKeyMapping.Builder withContext(KeyConflictContext context) {
        this.context = context;
        return this;
    }

    @Override
    public ManagedKeyMapping.Builder withDefault(InputBinding binding) {
        this.defaultBinding = binding;
        return this;
    }

    @Override
    public ManagedKeyMapping.Builder withFallbackDefault(InputBinding binding) {
        this.fallbackBindings.add(binding);
        return this;
    }

    @Override
    public ManagedKeyMapping.Builder handleWorldInput(WorldInputEventHandler handler) {
        this.worldInputHandler = handler;
        return this;
    }

    @Override
    public ManagedKeyMapping.Builder forceVirtual() {
        this.forceVirtual = true;
        return this;
    }

    @Override
    public ManagedKeyMapping.Builder handleScreenInput(ScreenInputEventHandler handler) {
        this.screenInputHandler = handler;
        return this;
    }

    @Override
    public ManagedKeyMapping.Builder enableKeyRepeat() {
        this.keyRepeat = true;
        return this;
    }

    @Override
    public ManagedKeyMapping.Builder disableKeyRepeat() {
        this.keyRepeat = false;
        return this;
    }

    private KeyConflictContext determineContext() {
        if (this.worldInputHandler != null && this.screenInputHandler == null) {
            return KeyConflictContext.WORLD;
        }
        if (this.screenInputHandler != null && this.worldInputHandler == null) {
            return KeyConflictContext.SCREEN;
        }
        return KeyConflictContext.UNIVERSAL;
    }

    private Optional<InputBinding> determineBinding() {
        if (Kuma.isBindingSupported(this.defaultBinding, this.context)) {
            return Optional.of(this.defaultBinding);
        }
        for (InputBinding binding : this.fallbackBindings) {
            if (!Kuma.isBindingSupported(binding, this.context)) continue;
            return Optional.of(binding);
        }
        return Optional.empty();
    }

    @Override
    public ManagedKeyMapping build() {
        String name = String.format("key.%s.%s", this.id.method_12836(), this.id.method_12832());
        if (this.context == null) {
            this.context = this.determineContext();
        }
        Optional<InputBinding> effectiveBinding = this.determineBinding();
        ManagedKeyMapping managedKeyMapping = effectiveBinding.map(it -> {
            if (this.forceVirtual) {
                return null;
            }
            return this.createVanillaKeyMapping(name, (InputBinding)it);
        }).orElseGet(() -> new VirtualManagedKeyMapping(this.context, this.screenInputHandler, this.worldInputHandler, this.keyRepeat, this.defaultBinding));
        ManagedKeyMappingRegistry.register(managedKeyMapping);
        return managedKeyMapping;
    }

    protected abstract VanillaManagedKeyMapping createVanillaKeyMapping(String var1, InputBinding var2);
}

